unit Sql;

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, StdCtrls, Buttons, DB, Grids, DBGrids, DBTables, sqlabout,
  Menus;

type
  TSQLForm = class(TForm)
    SQL_Statement: TMemo;
    SQL_Output: TMemo;
    CCS_SQL: TQuery;
    iSQL_DS: TDataSource;
    SQL_Out: TDBGrid;
    dbMain: TDatabase;
    RunButton: TBitBtn;
    ViewButton: TBitBtn;
    CloseButton: TBitBtn;
    AliasBox: TComboBox;
    Label1: TLabel;
    ExitButton: TBitBtn;
    MainMenu1: TMainMenu;
    procedure RunButtonClick(Sender: TObject);
    procedure ViewButtonClick(Sender: TObject);
    procedure CloseButtonClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure AliasBoxClick(Sender: TObject);
    procedure ExitButtonClick(Sender: TObject);
  private
    { Private declarations }
  public
    SQL_Alias: String;
    { Public declarations }
  end;

  procedure procGoSQL;

var
  SQLForm: TSQLForm;

implementation

{$R *.DFM}

procedure TSQLForm.RunButtonClick(Sender: TObject);
begin
  procGoSQL;
end;


procedure procGoSQL;

begin
   screen.cursor:=crHourglass;

     {Prepare and Execute the SQL Statement}
     SQLForm.SQL_Output.Clear;
     SQLForm.CCS_SQL.Close;
     SQLForm.CCS_SQL.SQL.Clear;
     SQLForm.CCS_SQL.SQL.Add(SQLForm.SQL_Statement.Text);
     try
       SQLForm.SQL_Output.Enabled := True;
       SQLForm.SQL_Output.Lines.Add('SQL: Executing......');
       SQLForm.SQL_Output.Lines.Add
          ('SQL: <' + SQLForm.SQL_Statement.Text + '>');
       SQLForm.CCS_SQL.ExecSQL;
       try
         SQLForm.CCS_SQL.Active := True;
         SQLForm.SQL_Output.Visible := False;
       except
         on E: EDatabaseError do
         begin
           SQLForm.SQL_Output.Lines.Add('SQL: Output Not Viewable...');
         end;
       end;
     except
       on E: EDatabaseError do
          begin
          SQLForm.SQL_Output.Lines.Add('SQL: FAILED - ' + E.Message);
          end;
     end;

   screen.cursor:=crDefault;
   SQLForm.SQL_Output.Lines.Add('SQL: Task Completed.');

end;

procedure TSQLForm.ViewButtonClick(Sender: TObject);
  begin

    try
      SQLForm.CCS_SQL.Active := True;
      SQLForm.SQL_Output.Visible := False;
    except
      on E: EDatabaseError do
      begin
        SQLForm.SQL_Output.Lines.Add('SQL: Output Not Viewable...');
      end;
    end;

  end;

procedure TSQLForm.CloseButtonClick(Sender: TObject);
begin
   SQLForm.CCS_SQL.Active := False;
   SQLForm.SQL_Output.Visible := True;
end;

procedure TSQLForm.FormCreate(Sender: TObject);
begin
   Session.GetDatabaseNames(AliasBox.Items);
   {AliasBox.Items.Delete('iSQL');}
end;

procedure TSQLForm.AliasBoxClick(Sender: TObject);
begin
  SQL_Alias := AliasBox.Items.Strings[AliasBox.ItemIndex];
  SQLForm.SQL_Output.Lines.Add('Alias: ' + SQL_Alias);
  dbMain.Connected:=False;
  dbMain.ALIASName:=SQL_Alias;
  Screen.Cursor:=crHourglass;
  try
    dbMain.Connected:=True;
    SQLForm.SQL_Output.Lines.Add('SQL: Sucessful Connection');
  except
    on E: EDatabaseError do
      begin
      SQLForm.SQL_Output.Lines.Add('SQL: Connection Failed - ');
      screen.Cursor:=crDefault;
      end;
  end;
  SQLForm.SQL_Statement.SetFocus;
end;

procedure TSQLForm.ExitButtonClick(Sender: TObject);
begin
   SQLForm.CCS_SQL.Active := False;
   dbMain.Connected := False;
   AboutBox.ShowModal;
   Close;
end;

end.
